function bodyScrollLock(){
    var scrollHeight = window.scrollY;
    $('body').toggleClass('scroll-lock');
    if($('body').hasClass('scroll-lock')){
        $('body').css('top',-(scrollHeight));
    }else{
        var scrollPosition = $('body').css('top').replace(/[^0-9]/g, '');
        $(window).scrollTop(scrollPosition);
        $('body').css('top','');
    }
}
function bodyScrollUnlock(){
    $('body').removeClass('scroll-lock');
    var scrollPosition = $('body').css('top').replace(/[^0-9]/g, '');
    $(window).scrollTop(scrollPosition);
    $('body').css('top','');
}
$(window).on('load resize',function(){
    if(window.matchMedia("(max-width: 767.98px)").matches){
        //header
        if(!$('header .nav').hasClass('sp')){
            $('header .nav').addClass('sp');
        }
    }else{
        //header
        if($('header .nav').hasClass('sp')){
            $('header .nav').removeClass('sp');
            $('button[data-btn="hnav"]').removeClass('active');
            $('header .nav').removeClass('active');
            bodyScrollUnlock();
        }
    }
})
$(function(){
    //common
    $('a[href^="#"]').not('a.notscroll').click(function(){
        let speed = 500;
        let headerHeight = $('header').innerHeight();
        let href= $(this).attr("href");
        let target = $(href == "#" || href == "" ? 'html' : href);
        let position = target.offset().top - headerHeight;
        $("html, body").animate({scrollTop:position}, speed, "swing");
        return false;
    });
    //header
    $('button[data-btn="hnav"]').on('click',function(){
        $(this).toggleClass('active');
        $('header .nav').toggleClass('active');
        if($('body').hasClass('scroll-lock')){
            bodyScrollUnlock();
        }else{
            bodyScrollLock();
        }
    })
})
